local __RUNLATER = {} UMF_RUNLATER = function(code) __RUNLATER[#__RUNLATER + 1] = code end
(function() if hook then return end local hook_table = {} local hook_compiled = {} local function recompile( event ) local hooks = {} for k, v in pairs( hook_table[event] ) do hooks[#hooks + 1] = v end hook_compiled[event] = hooks end hook = { table = hook_table } function hook.add( event, identifier, func ) assert( type( event ) == "string", "Event must be a string" ) if func then assert( identifier ~= nil, "Identifier must not be nil" ) assert( type( func ) == "function", "Callback must be a function" ) else assert( type( identifier ) == "function", "Callback must be a function" ) end hook_table[event] = hook_table[event] or {} hook_table[event][identifier] = func or identifier recompile( event ) return identifier end function hook.remove( event, identifier ) assert( type( event ) == "string", "Event must be a string" ) assert( identifier ~= nil, "Identifier must not be nil" ) if hook_table[event] then hook_table[event][identifier] = nil if next( hook_table[event] ) == nil then hook_table[event] = nil hook_compiled[event] = nil else recompile( event ) end end end function hook.run( event, ... ) local hooks = hook_compiled[event] if not hooks then return end for i = 1, #hooks do local a, b, c, d, e = hooks[i]( ... ) if a ~= nil then return a, b, c, d, e end end end function hook.saferun( event, ... ) local hooks = hook_compiled[event] if not hooks then return end for i = 1, #hooks do local s, a, b, c, d, e = softassert( pcall( hooks[i], ... ) ) if s and a ~= nil then return a, b, c, d, e end end end function hook.used( event ) return hook_table[event] end end)();
(function() local original = {} local function call_original( name, ... ) local fn = original[name] if fn then return fn( ... ) end end local detoured = {} function DETOUR( name, generator ) original[name] = _G[name] detoured[name] = generator( function( ... ) return call_original( name, ... ) end ) rawset( _G, name, nil ) end setmetatable( _G, { __index = detoured, __newindex = function( self, k, v ) if detoured[k] then original[k] = v else rawset( self, k, v ) end end, } ) end)();
(function() UMF_RUNLATER "UpdateQuickloadPatch()" local hook = hook local function checkoriginal( b, ... ) if not b then printerror( ... ) return end return ... end local function simple_detour( name ) local event = "base." .. name DETOUR( name, function( original ) return function( ... ) hook.saferun( event, ... ) return checkoriginal( pcall( original, ... ) ) end end ) end local detours = { "init", "tick", "update", } for i = 1, #detours do simple_detour( detours[i] ) end function shoulddraw( kind ) return hook.saferun( "api.shoulddraw", kind ) ~= false end DETOUR( "draw", function( original ) return function( dt ) if shoulddraw( "all" ) then hook.saferun( "base.predraw", dt ) if shoulddraw( "original" ) then checkoriginal( pcall( original, dt ) ) end hook.saferun( "base.draw", dt ) end end end ) DETOUR( "Command", function( original ) return function( cmd, ... ) hook.saferun( "base.precmd", cmd, { ... } ) local a, b, c, d, e, f = original( cmd, ... ) hook.saferun( "base.postcmd", cmd, { ... }, { a, b, c, d, e, f } ) end end ) local saved = {} local function hasfunction( t, bck ) if bck[t] then return end bck[t] = true for k, v in pairs( t ) do if type( v ) == "function" then return true end if type( v ) == "table" and hasfunction( v, bck ) then return true end end end function UpdateQuickloadPatch() for k, v in pairs( _G ) do if k ~= "_G" and type( v ) == "table" and hasfunction( v, {} ) then saved[k] = v end end end local quickloadfix = function() for k, v in pairs( saved ) do _G[k] = v end end DETOUR( "handleCommand", function( original ) return function( command, ... ) if command == "quickload" then quickloadfix() end hook.saferun( "base.command." .. command, ... ) return original( command, ... ) end end ) hook.add( "base.tick", "api.firsttick", function() hook.remove( "base.tick", "api.firsttick" ) hook.saferun( "api.firsttick" ) if type( firsttick ) == "function" then firsttick() end end ) end)();
(function() function IsPlayerInVehicle() return GetBool( "game.player.usevehicle" ) end local tool = GetString( "game.player.tool" ) local invehicle = IsPlayerInVehicle() local keyboardkeys = { "esc", "up", "down", "left", "right", "space", "interact", "return" } for i = 97, 97 + 25 do keyboardkeys[#keyboardkeys + 1] = string.char( i ) end local function checkkeys( func, mousehook, keyhook ) if hook.used( keyhook ) and func( "any" ) then for i = 1, #keyboardkeys do if func( keyboardkeys[i] ) then hook.saferun( keyhook, keyboardkeys[i] ) end end end if hook.used( mousehook ) then if func( "lmb" ) then hook.saferun( mousehook, "lmb" ) end if func( "rmb" ) then hook.saferun( mousehook, "rmb" ) end end end local mousekeys = { "lmb", "rmb", "mmb" } local heldkeys = {} hook.add( "base.tick", "api.default_hooks", function() if InputLastPressedKey then for i = 1, #mousekeys do local k = mousekeys[i] if InputPressed( k ) then hook.saferun( "api.mouse.pressed", k ) elseif InputReleased( k ) then hook.saferun( "api.mouse.released", k ) end end local lastkey = InputLastPressedKey() if lastkey ~= "" then heldkeys[lastkey] = true hook.saferun( "api.key.pressed", lastkey ) end for key in pairs( heldkeys ) do if not InputDown( key ) then heldkeys[key] = nil hook.saferun( "api.key.released", key ) break end end local wheel = InputValue( "mousewheel" ) if wheel ~= 0 then hook.saferun( "api.mouse.wheel", wheel ) end local mousedx = InputValue( "mousedx" ) local mousedy = InputValue( "mousedy" ) if mousedx ~= 0 or mousedy ~= 0 then hook.saferun( "api.mouse.move", mousedx, mousedy ) end elseif InputPressed then checkkeys( InputPressed, "api.mouse.pressed", "api.key.pressed" ) checkkeys( InputReleased, "api.mouse.released", "api.key.released" ) local wheel = InputValue( "mousewheel" ) if wheel ~= 0 then hook.saferun( "api.mouse.wheel", wheel ) end local mousedx = InputValue( "mousedx" ) local mousedy = InputValue( "mousedy" ) if mousedx ~= 0 or mousedy ~= 0 then hook.saferun( "api.mouse.move", mousedx, mousedy ) end end local n_invehicle = IsPlayerInVehicle() if invehicle ~= n_invehicle then hook.saferun( n_invehicle and "api.player.enter_vehicle" or "api.player.exit_vehicle", n_invehicle and GetPlayerVehicle() ) invehicle = n_invehicle end local n_tool = GetString( "game.player.tool" ) if tool ~= n_tool then hook.saferun( "api.player.switch_tool", n_tool, tool ) tool = n_tool end end ) end)();
(function() util = util or {} do local serialize_any, serialize_table serialize_table = function( val, bck ) if bck[val] then return "nil" end bck[val] = true local entries = {} for k, v in pairs( val ) do entries[#entries + 1] = string.format( "[%s] = %s", serialize_any( k, bck ), serialize_any( v, bck ) ) end return string.format( "{%s}", table.concat( entries, "," ) ) end serialize_any = function( val, bck ) local vtype = type( val ) if vtype == "table" then return serialize_table( val, bck ) elseif vtype == "string" then return string.format( "%q", val ) elseif vtype == "function" or vtype == "userdata" then return string.format( "nil ", tostring( val ) ) else return tostring( val ) end end function util.serialize( ... ) local result = {} for i = 1, select( "#", ... ) do result[i] = serialize_any( select( i, ... ), {} ) end return table.concat( result, "," ) end end function util.unserialize( dt ) local fn = loadstring( "return " .. dt ) if fn then setfenv( fn, {} ) return fn() end end do local function serialize_any( val, bck ) local vtype = type( val ) if vtype == "table" then if bck[val] then return "{}" end bck[val] = true local len = 0 for k, v in pairs( val ) do len = len + 1 end local rt = {} if len == #val then for i = 1, #val do rt[i] = serialize_any( val[i], bck ) end return string.format( "[%s]", table.concat( rt, "," ) ) else for k, v in pairs( val ) do if type( k ) == "string" or type( k ) == "number" then rt[#rt + 1] = string.format( "%s: %s", serialize_any( k, bck ), serialize_any( v, bck ) ) end end return string.format( "{%s}", table.concat( rt, "," ) ) end elseif vtype == "string" then return string.format( "%q", val ) elseif vtype == "function" or vtype == "userdata" or vtype == "nil" then return "null" else return tostring( val ) end end function util.serializeJSON( val ) return serialize_any( val, {} ) end end function util.shared_buffer( name, max ) max = max or 64 return { _pos_name = name .. ".position", _list_name = name .. ".list.", push = function( self, text ) local cpos = GetInt( self._pos_name ) SetString( self._list_name .. (cpos % max), text ) SetInt( self._pos_name, cpos + 1 ) end, len = function( self ) return math.min( GetInt( self._pos_name ), max ) end, pos = function( self ) return GetInt( self._pos_name ) end, get = function( self, index ) local pos = GetInt( self._pos_name ) local len = math.min( pos, max ) if index >= len then return end return GetString( self._list_name .. (pos + index - len) % max ) end, get_g = function( self, index ) return GetString( self._list_name .. (index % max) ) end, clear = function( self ) SetInt( self._pos_name, 0 ) ClearKey( self._list_name:sub( 1, -2 ) ) end, } end function util.shared_channel( name, max, local_realm ) max = max or 64 local channel = { _buffer = util.shared_buffer( name, max ), _offset = 0, _hooks = {}, _ready_count = 0, _ready = {}, broadcast = function( self, ... ) return self:send( "", ... ) end, send = function( self, realm, ... ) self._buffer:push( string.format( ",%s,;%s", (type( realm ) == "table" and table.concat( realm, "," ) or tostring( realm )), util.serialize( ... ) ) ) end, listen = function( self, callback ) if self._ready[callback] ~= nil then return end self._hooks[#self._hooks + 1] = callback self:ready( callback ) return callback end, unlisten = function( self, callback ) self:unready( callback ) self._ready[callback] = nil for i = 1, #self._hooks do if self._hooks[i] == callback then table.remove( self._hooks, i ) return true end end end, ready = function( self, callback ) if not self._ready[callback] then self._ready_count = self._ready_count + 1 self._ready[callback] = true end end, unready = function( self, callback ) if self._ready[callback] then self._ready_count = self._ready_count - 1 self._ready[callback] = false end end, } local_realm = "," .. (local_realm or "unknown") .. "," local function receive( ... ) for i = 1, #channel._hooks do local f = channel._hooks[i] if channel._ready[f] then f( channel, ... ) end end end hook.add( "base.tick", name, function( dt ) if channel._ready_count > 0 then local last_pos = channel._buffer:pos() if last_pos > channel._offset then for i = math.max( channel._offset, last_pos - max ), last_pos - 1 do local message = channel._buffer:get_g( i ) local start = message:find( ";", 1, true ) local realms = message:sub( 1, start - 1 ) if realms == ",," or realms:find( local_realm, 1, true ) then receive( util.unserialize( message:sub( start + 1 ) ) ) if channel._ready_count <= 0 then channel._offset = i + 1 return end end end channel._offset = last_pos end end end ) return channel end function util.async_channel( channel ) local listener = { _channel = channel, _waiter = nil, read = function( self ) self._waiter = coroutine.running() if not self._waiter then error( "async_channel:read() can only be used in a coroutine" ) end self._channel:ready( self._handler ) return coroutine.yield() end, close = function( self ) if self._handler then self._channel:unlisten( self._handler ) end end, } listener._handler = listener._channel:listen( function( _, ... ) if listener._waiter then local co = listener._waiter listener._waiter = nil listener._channel:unready( listener._handler ) return coroutine.resume( co, ... ) end end ) listener._channel:unready( listener._handler ) return listener end do local gets, sets = {}, {} function util.register_unserializer( type, callback ) gets[type] = function( key ) return callback( GetString( key ) ) end end hook.add( "api.newmeta", "api.createunserializer", function( name, meta ) gets[name] = function( key ) return setmetatable( {}, meta ):__unserialize( GetString( key ) ) end sets[name] = function( key, value ) return SetString( key, meta.__serialize( value ) ) end end ) function util.shared_table( name, base ) return setmetatable( base or {}, { __index = function( self, k ) local key = tostring( k ) local vtype = GetString( string.format( "%s.%s.type", name, key ) ) if vtype == "" then return end return gets[vtype]( string.format( "%s.%s.val", name, key ) ) end, __newindex = function( self, k, v ) local vtype = type( v ) local handler = sets[vtype] if not handler then return end local key = tostring( k ) if vtype == "table" then local meta = getmetatable( v ) if meta and meta.__serialize and meta.__type then vtype = meta.__type v = meta.__serialize( v ) handler = sets.string end end SetString( string.format( "%s.%s.type", name, key ), vtype ) handler( string.format( "%s.%s.val", name, key ), v ) end, } ) end function util.structured_table( name, base ) local function generate( base ) local root = {} local keys = {} for k, v in pairs( base ) do local key = name .. "." .. tostring( k ) if type( v ) == "table" then root[k] = util.structured_table( key, v ) elseif type( v ) == "string" then keys[k] = { type = v, key = key } else root[k] = v end end return setmetatable( root, { __index = function( self, k ) local entry = keys[k] if entry and gets[entry.type] then return gets[entry.type]( entry.key ) end end, __newindex = function( self, k, v ) local entry = keys[k] if entry and sets[entry.type] then return sets[entry.type]( entry.key, v ) end end, } ) end if type( base ) == "table" then return generate( base ) end return generate end gets.number = GetFloat gets.integer = GetInt gets.boolean = GetBool gets.string = GetString gets.table = util.shared_table sets.number = SetFloat sets.integer = SetInt sets.boolean = SetBool sets.string = SetString sets.table = function( key, val ) local tab = util.shared_table( key ) for k, v in pairs( val ) do tab[k] = v end end end end)();
(function() util = util or {} function util.current_line( level ) level = (level or 0) + 3 local _, line = pcall( error, "-", level ) if line == "-" then _, line = pcall( error, "-", level + 1 ) if line == "-" then return end line = "[C]:?" else line = line:sub( 1, -4 ) end return line end function util.stacktrace( start ) start = (start or 0) + 3 local stack, last = {}, nil for i = start, 32 do local _, line = pcall( error, "-", i ) if line == "-" then if last == "-" then break end else if last == "-" then stack[#stack + 1] = "[C]:?" end stack[#stack + 1] = line:sub( 1, -4 ) end last = line end return stack end end)();
(function() local console_buffer = util.shared_buffer( "game.console", 128 ) local function maketext( ... ) local text = "" local len = select( "#", ... ) for i = 1, len do local s = tostring( select( i, ... ) ) if i < len then s = s .. string.rep( " ", 8 - #s % 8 ) end text = text .. s end return text end _OLDPRINT = _OLDPRINT or print function printcolor( r, g, b, ... ) local text = maketext( ... ) console_buffer:push( string.format( "%f;%f;%f;%s", r, g, b, text ) ) if PRINTTOSCREEN then DebugPrint( text ) end return _OLDPRINT( ... ) end function print( ... ) printcolor( 1, 1, 1, ... ) end function printinfo( ... ) printcolor( 0, .6, 1, ... ) end function warning( msg ) printcolor( 1, .7, 0, "[WARNING] " .. tostring( msg ) .. "\n " .. table.concat( util.stacktrace( 1 ), "\n " ) ) end printwarning = warning function printerror( ... ) printcolor( 1, .2, 0, ... ) end function clearconsole() console_buffer:clear() end function softassert( b, ... ) if not b then printerror( ... ) end return b, ... end function assert( b, msg, ... ) if not b then local m = msg or "Assertion failed" warning( m ) return error( m, ... ) end return b, msg, ... end end)();
(function() GLOBAL_CHANNEL = util.shared_channel( "game.umf_global_channel", 128 ) end)();
(function() local registered_meta = {} local reverse_meta = {} function global_metatable( name, parent ) local meta = registered_meta[name] if meta then if not parent then return meta end else meta = {} meta.__index = meta meta.__type = name registered_meta[name] = meta reverse_meta[meta] = name hook.saferun( "api.newmeta", name, meta ) end if parent then setmetatable( meta, global_metatable( parent ) ) end return meta end function find_global_metatable( name ) if not name then return end if type( name ) == "table" then return reverse_meta[name] end return registered_meta[name] end local function findmeta( src, found ) if found[src] then return end found[src] = true local res for k, v in pairs( src ) do if type( v ) == "table" then local dt local m = getmetatable( v ) if m then local name = reverse_meta[m] if name then dt = {} dt[1] = name end end local sub = findmeta( v, found ) if sub then dt = dt or {} dt[2] = sub end if dt then res = res or {} res[k] = dt end end end return res end local previous = -2 hook.add( "base.tick", "api.metatables.save", function( ... ) if GetTime() - previous > 2 then previous = GetTime() _G.GLOBAL_META_SAVE = findmeta( _G, {} ) end end ) local function restoremeta( dst, src ) for k, v in pairs( src ) do local dv = dst[k] if type( dv ) == "table" then if v[1] then setmetatable( dv, global_metatable( v[1] ) ) end if v[2] then restoremeta( dv, v[2] ) end end end end hook.add( "base.command.quickload", "api.metatables.restore", function( ... ) if GLOBAL_META_SAVE then restoremeta( _G, GLOBAL_META_SAVE ) end end ) end)();
(function() local vector_meta = global_metatable( "vector" ) local quat_meta = global_metatable( "quaternion" ) function IsQuaternion( q ) return type( q ) == "table" and type( q[1] ) == "number" and type( q[2] ) == "number" and type( q[3] ) == "number" and type( q[4] ) == "number" end function MakeQuaternion( q ) return setmetatable( q, quat_meta ) end function Quaternion( i, j, k, r ) if IsQuaternion( i ) then i, j, k, r = i[1], i[2], i[3], i[4] end return MakeQuaternion { i or 0, j or 0, k or 0, r or 1 } end function quat_meta:__unserialize( data ) local i, j, k, r = data:match( "([-0-9.]*);([-0-9.]*);([-0-9.]*);([-0-9.]*)" ) self[1] = tonumber( i ) self[2] = tonumber( j ) self[3] = tonumber( k ) self[4] = tonumber( r ) return self end function quat_meta:__serialize() return table.concat( self, ";" ) end QUAT_ZERO = Quaternion() function quat_meta:Clone() return MakeQuaternion { self[1], self[2], self[3], self[4] } end local QuatStr = QuatStr function quat_meta:__tostring() return QuatStr( self ) end function quat_meta:__unm() return MakeQuaternion { -self[1], -self[2], -self[3], -self[4] } end function quat_meta:Conjugate() return MakeQuaternion { -self[1], -self[2], -self[3], self[4] } end function quat_meta:Add( o ) if IsQuaternion( o ) then self[1] = self[1] + o[1] self[2] = self[2] + o[2] self[3] = self[3] + o[3] self[4] = self[4] + o[4] else self[1] = self[1] + o self[2] = self[2] + o self[3] = self[3] + o self[4] = self[4] + o end return self end function quat_meta.__add( a, b ) if not IsQuaternion( a ) then a, b = b, a end return quat_meta.Add( quat_meta.Clone( a ), b ) end function quat_meta:Sub( o ) if IsQuaternion( o ) then self[1] = self[1] - o[1] self[2] = self[2] - o[2] self[3] = self[3] - o[3] self[4] = self[4] - o[4] else self[1] = self[1] - o self[2] = self[2] - o self[3] = self[3] - o self[4] = self[4] - o end return self end function quat_meta.__sub( a, b ) if not IsQuaternion( a ) then a, b = b, a end return quat_meta.Sub( quat_meta.Clone( a ), b ) end function quat_meta:Mul( o ) local i1, j1, k1, r1 = self[1], self[2], self[3], self[4] local i2, j2, k2, r2 = o[1], o[2], o[3], o[4] self[1] = j1 * k2 - k1 * j2 + r1 * i2 + i1 * r2 self[2] = k1 * i2 - i1 * k2 + r1 * j2 + j1 * r2 self[3] = i1 * j2 - j1 * i2 + r1 * k2 + k1 * r2 self[4] = r1 * r2 - i1 * i2 - j1 * j2 - k1 * k2 return self end function quat_meta.__mul( a, b ) if not IsQuaternion( a ) then a, b = b, a end if type( b ) == "number" then return Quaternion( a[1] * b, a[2] * b, a[3] * b, a[4] * b ) end if IsVector( b ) then return vector_meta.__mul( b, a ) end if IsTransformation( b ) then return Transformation( vector_meta.Mul( vector_meta.Clone( b.pos ), a ), QuatRotateQuat( b.rot, a ) ) end return MakeQuaternion( QuatRotateQuat( a, b ) ) end function quat_meta:Div( o ) self[1] = self[1] / o self[2] = self[2] / o self[3] = self[3] / o self[4] = self[4] / o return self end function quat_meta.__div( a, b ) return quat_meta.Div( quat_meta.Clone( a ), b ) end function quat_meta.__eq( a, b ) return a[1] == b[1] and a[2] == b[2] and a[3] == b[3] and a[4] == b[4] end function quat_meta:LengthSquare() return self[1] ^ 2 + self[2] ^ 2 + self[3] ^ 2 + self[4] ^ 2 end function quat_meta:Length() return math.sqrt( quat_meta.LengthSquare( self ) ) end local QuatSlerp = QuatSlerp function quat_meta:Slerp( o, n ) return MakeQuaternion( QuatSlerp( self, o, n ) ) end function quat_meta:Left() local x, y, z, s = self[1], self[2], self[3], self[4] return Vector( 1 - (y ^ 2 + z ^ 2) * 2, (z * s + x * y) * 2, (x * z - y * s) * 2 ) end function quat_meta:Up() local x, y, z, s = self[1], self[2], self[3], self[4] return Vector( (y * x - z * s) * 2, 1 - (z ^ 2 + x ^ 2) * 2, (x * s + y * z) * 2 ) end function quat_meta:Forward() local x, y, z, s = self[1], self[2], self[3], self[4] return Vector( (y * s + z * x) * 2, (z * y - x * s) * 2, 1 - (x ^ 2 + y ^ 2) * 2 ) end function quat_meta:ToEuler() if GetQuatEuler then return GetQuatEuler( self ) end local x, y, z, w = self[1], self[2], self[3], self[4] local bank, heading, attitude local s = 2 * x * y + 2 * z * w if s >= 1 then heading = 2 * math.atan2( x, w ) bank = 0 attitude = math.pi / 2 elseif s <= -1 then heading = -2 * math.atan2( x, w ) bank = 0 attitude = math.pi / -2 else bank = math.atan2( 2 * x * w - 2 * y * z, 1 - 2 * x ^ 2 - 2 * z ^ 2 ) heading = math.atan2( 2 * y * w - 2 * x * z, 1 - 2 * y ^ 2 - 2 * z ^ 2 ) attitude = math.asin( s ) end return math.deg( bank ), math.deg( heading ), math.deg( attitude ) end function quat_meta:Approach( dest, rate ) local dot = self[1] * dest[1] + self[2] * dest[2] + self[3] * dest[3] + self[4] * dest[4] if dot >= 1 then return self end local corr_rate = rate / math.acos( 2 * dot ^ 2 - 1 ) if corr_rate >= 1 then return MakeQuaternion( dest ) end return MakeQuaternion( QuatSlerp( self, dest, corr_rate ) ) end end)();
(function() local vector_meta = global_metatable( "vector" ) local quat_meta = global_metatable( "quaternion" ) local transform_meta = global_metatable( "transformation" ) function IsTransformation( t ) return type( t ) == "table" and t.pos and t.rot end function MakeTransformation( t ) setmetatable( t.pos, vector_meta ) setmetatable( t.rot, quat_meta ) return setmetatable( t, transform_meta ) end function Transformation( pos, rot ) return MakeTransformation { pos = pos, rot = rot } end function transform_meta:__unserialize( data ) local x, y, z, i, j, k, r = data:match( "([-0-9.]*);([-0-9.]*);([-0-9.]*);([-0-9.]*);([-0-9.]*);([-0-9.]*);([-0-9.]*)" ) self.pos = Vector( tonumber( x ), tonumber( y ), tonumber( z ) ) self.rot = Quaternion( tonumber( i ), tonumber( j ), tonumber( k ), tonumber( r ) ) return self end function transform_meta:__serialize() return table.concat( self.pos, ";" ) .. ";" .. table.concat( self.rot, ";" ) end function transform_meta:Clone() return MakeTransformation { pos = vector_meta.Clone( self.pos ), rot = quat_meta.Clone( self.rot ) } end local TransformStr = TransformStr function transform_meta:__tostring() return TransformStr( self ) end local TransformToLocalPoint = TransformToLocalPoint local TransformToLocalTransform = TransformToLocalTransform local TransformToLocalVec = TransformToLocalVec local TransformToParentPoint = TransformToParentPoint local TransformToParentTransform = TransformToParentTransform local TransformToParentVec = TransformToParentVec function transform_meta.__add( a, b ) if not IsTransformation( b ) then if IsVector( b ) then b = Transformation( b, QUAT_ZERO ) elseif IsQuaternion( b ) then b = Transformation( VEC_ZERO, b ) end end return MakeTransformation( TransformToParentTransform( a, b ) ) end function transform_meta:ToLocal( o ) if IsTransformation( o ) then return MakeTransformation( TransformToLocalTransform( self, o ) ) elseif IsQuaternion( o ) then return MakeQuaternion( TransformToLocalTransform( self, Transform( {}, o ) ).rot ) else return MakeVector( TransformToLocalPoint( self, o ) ) end end function transform_meta:ToLocalDir( o ) return MakeVector( TransformToLocalVec( self, o ) ) end function transform_meta:ToGlobal( o ) if IsTransformation( o ) then return MakeTransformation( TransformToParentTransform( self, o ) ) elseif IsQuaternion( o ) then return MakeQuaternion( TransformToParentTransform( self, Transform( {}, o ) ).rot ) else return MakeVector( TransformToParentPoint( self, o ) ) end end function transform_meta:ToGlobalDir( o ) return MakeVector( TransformToParentVec( self, o ) ) end function transform_meta:Raycast( dist, mul, radius, rejectTransparent ) local dir = TransformToParentVec( self, VEC_FORWARD ) if mul then vector_meta.Mul( dir, mul ) end local hit, dist2, normal, shape = QueryRaycast( self.pos, dir, dist, radius, rejectTransparent ) return { hit = hit, dist = dist2, normal = hit and MakeVector( normal ), shape = hit and Shape and Shape( shape ) or shape, hitpos = vector_meta.__add( self.pos, vector_meta.Mul( dir, hit and dist2 or dist ) ), } end end)();
(function() local vector_meta = global_metatable( "vector" ) local quat_meta = global_metatable( "quaternion" ) function IsVector( v ) return type( v ) == "table" and type( v[1] ) == "number" and type( v[2] ) == "number" and type( v[3] ) == "number" and not v[4] end function MakeVector( v ) return setmetatable( v, vector_meta ) end function Vector( x, y, z ) if IsVector( x ) then x, y, z = x[1], x[2], x[3] end return MakeVector { x or 0, y or 0, z or 0 } end function vector_meta:__unserialize( data ) local x, y, z = data:match( "([-0-9.]*);([-0-9.]*);([-0-9.]*)" ) self[1] = tonumber( x ) self[2] = tonumber( y ) self[3] = tonumber( z ) return self end function vector_meta:__serialize() return table.concat( self, ";" ) end VEC_ZERO = Vector() VEC_FORWARD = Vector( 0, 0, 1 ) VEC_UP = Vector( 0, 1, 0 ) VEC_LEFT = Vector( 1, 0, 0 ) function vector_meta:Clone() return MakeVector { self[1], self[2], self[3] } end local VecStr = VecStr function vector_meta:__tostring() return VecStr( self ) end function vector_meta:__unm() return MakeVector { -self[1], -self[2], -self[3] } end function vector_meta:Add( o ) if IsVector( o ) then self[1] = self[1] + o[1] self[2] = self[2] + o[2] self[3] = self[3] + o[3] else self[1] = self[1] + o self[2] = self[2] + o self[3] = self[3] + o end return self end function vector_meta.__add( a, b ) if not IsVector( a ) then a, b = b, a end if IsTransformation( b ) then return Transformation( vector_meta.Add( vector_meta.Clone( a ), b.pos ), quat_meta.Clone( b.rot ) ) end return vector_meta.Add( vector_meta.Clone( a ), b ) end function vector_meta:Sub( o ) if IsVector( o ) then self[1] = self[1] - o[1] self[2] = self[2] - o[2] self[3] = self[3] - o[3] else self[1] = self[1] - o self[2] = self[2] - o self[3] = self[3] - o end return self end function vector_meta.__sub( a, b ) if not IsVector( a ) then a, b = b, a end return vector_meta.Sub( vector_meta.Clone( a ), b ) end function vector_meta:Mul( o ) if IsVector( o ) then self[1] = self[1] * o[1] self[2] = self[2] * o[2] self[3] = self[3] * o[3] elseif IsQuaternion( o ) then local x1, y1, z1 = self[1], self[2], self[3] local x2, y2, z2, s = o[1], o[2], o[3], o[4] local x3 = y2 * z1 - z2 * y1 local y3 = z2 * x1 - x2 * z1 local z3 = x2 * y1 - y2 * x1 self[1] = x1 + (x3 * s + y2 * z3 - z2 * y3) * 2 self[2] = y1 + (y3 * s + z2 * x3 - x2 * z3) * 2 self[3] = z1 + (z3 * s + x2 * y3 - y2 * x3) * 2 else self[1] = self[1] * o self[2] = self[2] * o self[3] = self[3] * o end return self end function vector_meta.__mul( a, b ) if not IsVector( a ) then a, b = b, a end return vector_meta.Mul( vector_meta.Clone( a ), b ) end function vector_meta:Div( o ) self[1] = self[1] / o self[2] = self[2] / o self[3] = self[3] / o return self end function vector_meta.__div( a, b ) return vector_meta.Div( vector_meta.Clone( a ), b ) end function vector_meta:Mod( o ) self[1] = self[1] % o self[2] = self[2] % o self[3] = self[3] % o return self end function vector_meta.__mod( a, b ) return vector_meta.Mod( vector_meta.Clone( a ), b ) end function vector_meta:Pow( o ) self[1] = self[1] ^ o self[2] = self[2] ^ o self[3] = self[3] ^ o return self end function vector_meta.__pow( a, b ) return vector_meta.Pow( vector_meta.Clone( a ), b ) end function vector_meta.__eq( a, b ) return a[1] == b[1] and a[2] == b[2] and a[3] == b[3] end function vector_meta.__lt( a, b ) return a[1] < b[1] or (a[1] == b[1] and (a[2] < b[2] or (a[2] == b[2] and (a[3] < b[3])))) end function vector_meta.__le( a, b ) return a[1] < b[1] or (a[1] == b[1] and (a[2] < b[2] or (a[2] == b[2] and (a[3] <= b[3])))) end local VecDot = VecDot function vector_meta:Dot( b ) return VecDot( self, b ) end local VecCross = VecCross function vector_meta:Cross( b ) return MakeVector( VecCross( self, b ) ) end local VecLength = VecLength function vector_meta:Length() return VecLength( self ) end function vector_meta:Volume() return math.abs( self[1] * self[2] * self[3] ) end local VecLerp = VecLerp function vector_meta:Lerp( o, n ) return MakeVector( VecLerp( self, o, n ) ) end local VecNormalize = VecNormalize function vector_meta:Normalized() return MakeVector( VecNormalize( self ) ) end function vector_meta:Normalize() return vector_meta.Div( self, vector_meta.Length( self ) ) end function vector_meta:DistSquare( o ) return (self[1] - o[1]) ^ 2 + (self[2] - o[2]) ^ 2 + (self[3] - o[3]) ^ 2 end function vector_meta:Distance( o ) return math.sqrt( vector_meta.DistSquare( self, o ) ) end function vector_meta:LookAt( o ) return MakeQuaternion( QuatLookAt( self, o ) ) end function vector_meta:Approach( dest, rate ) local dist = vector_meta.Distance( self, dest ) if dist < rate then return dest end return vector_meta.Lerp( self, dest, rate / dist ) end end)();
(function() local entity_meta = global_metatable( "entity" ) function GetEntityHandle( e ) if IsEntity( e ) then return e.handle end return e end function IsValid( e ) if type( e ) == "table" and e.IsValid then return e:IsValid() end return false end function IsEntity( e ) return type( e ) == "table" and type( e.handle ) == "number" end function Entity( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "unknown" }, entity_meta ) end end function entity_meta:__unserialize( data ) self.handle = tonumber( data ) return self end function entity_meta:__serialize() return tostring( self.handle ) end function entity_meta:__tostring() return string.format( "Entity[%d]", self.handle ) end function entity_meta:GetType() return self.type or "unknown" end local IsHandleValid = IsHandleValid function entity_meta:IsValid() return IsHandleValid( self.handle ) end local SetTag = SetTag function entity_meta:SetTag( tag, value ) assert( self:IsValid() ) return SetTag( self.handle, tag, value ) end local SetDescription = SetDescription function entity_meta:SetDescription( description ) assert( self:IsValid() ) return SetDescription( self.handle, description ) end local RemoveTag = RemoveTag function entity_meta:RemoveTag( tag ) assert( self:IsValid() ) return RemoveTag( self.handle, tag ) end local HasTag = HasTag function entity_meta:HasTag( tag ) assert( self:IsValid() ) return HasTag( self.handle, tag ) end local GetTagValue = GetTagValue function entity_meta:GetTagValue( tag ) assert( self:IsValid() ) return GetTagValue( self.handle, tag ) end local GetDescription = GetDescription function entity_meta:GetDescription() assert( self:IsValid() ) return GetDescription( self.handle ) end local Delete = Delete function entity_meta:Delete() return Delete( self.handle ) end end)();
(function() local body_meta = global_metatable( "body", "entity" ) function IsBody( e ) return IsEntity( e ) and e.type == "body" end function Body( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "body" }, body_meta ) end end function FindBodyByTag( tag, global ) return Body( FindBody( tag, global ) ) end function FindBodiesByTag( tag, global ) local t = FindBodies( tag, global ) for i = 1, #t do t[i] = Body( t[i] ) end return t end function body_meta:__tostring() return string.format( "Body[%d]", self.handle ) end function body_meta:ApplyImpulse( pos, vel ) assert( self:IsValid() ) return ApplyBodyImpulse( self.handle, pos, vel ) end function body_meta:ApplyLocalImpulse( pos, vel ) local transform = self:GetTransform() return self:ApplyImpulse( transform:ToGlobal( pos ), transform:ToGlobalDir( vel ) ) end function body_meta:DrawOutline( r, ... ) assert( self:IsValid() ) return DrawBodyOutline( self.handle, r, ... ) end function body_meta:DrawHighlight( amount ) assert( self:IsValid() ) return DrawBodyHighlight( self.handle, amount ) end function body_meta:SetTransform( tr ) assert( self:IsValid() ) return SetBodyTransform( self.handle, tr ) end function body_meta:SetDynamic( bool ) assert( self:IsValid() ) return SetBodyDynamic( self.handle, bool ) end function body_meta:SetVelocity( vel ) assert( self:IsValid() ) return SetBodyVelocity( self.handle, vel ) end function body_meta:SetAngularVelocity( avel ) assert( self:IsValid() ) return SetBodyAngularVelocity( self.handle, avel ) end function body_meta:GetTransform() assert( self:IsValid() ) return MakeTransformation( GetBodyTransform( self.handle ) ) end function body_meta:GetMass() assert( self:IsValid() ) return GetBodyMass( self.handle ) end function body_meta:GetVelocity() assert( self:IsValid() ) return MakeVector( GetBodyVelocity( self.handle ) ) end function body_meta:GetVelocityAtPos( pos ) assert( self:IsValid() ) return MakeVector( GetBodyVelocityAtPos( self.handle, pos ) ) end function body_meta:GetAngularVelocity() assert( self:IsValid() ) return MakeVector( GetBodyAngularVelocity( self.handle ) ) end function body_meta:GetShapes() assert( self:IsValid() ) local shapes = GetBodyShapes( self.handle ) for i = 1, #shapes do shapes[i] = Shape( shapes[i] ) end return shapes end function body_meta:GetVehicle() assert( self:IsValid() ) return Vehicle( GetBodyVehicle( self.handle ) ) end function body_meta:GetWorldBounds() assert( self:IsValid() ) local min, max = GetBodyBounds( self.handle ) return MakeVector( min ), MakeVector( max ) end function body_meta:GetLocalCenterOfMass() assert( self:IsValid() ) return MakeVector( GetBodyCenterOfMass( self.handle ) ) end function body_meta:GetWorldCenterOfMass() return self:GetTransform():ToGlobal( self:GetLocalCenterOfMass() ) end function body_meta:IsActive() assert( self:IsValid() ) return IsBodyActive( self.handle ) end function body_meta:IsDynamic() assert( self:IsValid() ) return IsBodyDynamic( self.handle ) end function body_meta:IsVisible( maxdist ) assert( self:IsValid() ) return IsBodyVisible( self.handle, maxdist ) end function body_meta:IsBroken() return not self:IsValid() or IsBodyBroken( self.handle ) end function body_meta:IsJointedToStatic() assert( self:IsValid() ) return IsBodyJointedToStatic( self.handle ) end end)();
(function() local joint_meta = global_metatable( "joint", "entity" ) function IsJoint( e ) return IsEntity( e ) and e.type == "joint" end function Joint( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "joint" }, joint_meta ) end end function FindJointByTag( tag, global ) return Joint( FindJoint( tag, global ) ) end function FindJointsByTag( tag, global ) local t = FindJoints( tag, global ) for i = 1, #t do t[i] = Joint( t[i] ) end return t end function joint_meta:__tostring() return string.format( "Joint[%d]", self.handle ) end function joint_meta:SetMotor( velocity, strength ) assert( self:IsValid() ) return SetJointMotor( self.handle, velocity, strength ) end function joint_meta:SetMotorTarget( target, maxVel, strength ) assert( self:IsValid() ) return SetJointMotorTarget( self.handle, target, maxVel, strength ) end function joint_meta:GetJointType() assert( self:IsValid() ) return GetJointType( self.handle ) end function joint_meta:GetOtherShape( shape ) assert( self:IsValid() ) return Shape( GetJointOtherShape( self.handle, GetEntityHandle( shape ) ) ) end function joint_meta:GetLimits() assert( self:IsValid() ) return GetJointLimits( self.handle ) end function joint_meta:GetMovement() assert( self:IsValid() ) return GetJointMovement( self.handle ) end function joint_meta:IsBroken() return not self:IsValid() or IsJointBroken( self.handle ) end end)();
(function() local light_meta = global_metatable( "light", "entity" ) function IsLight( e ) return IsEntity( e ) and e.type == "light" end function Light( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "light" }, light_meta ) end end function FindLightByTag( tag, global ) return Light( FindLight( tag, global ) ) end function FindLightsByTag( tag, global ) local t = FindLights( tag, global ) for i = 1, #t do t[i] = Light( t[i] ) end return t end function light_meta:__tostring() return string.format( "Light[%d]", self.handle ) end function light_meta:SetEnabled( enabled ) assert( self:IsValid() ) return SetLightEnabled( self.handle, enabled ) end function light_meta:SetColor( r, g, b ) assert( self:IsValid() ) return SetLightColor( self.handle, r, g, b ) end function light_meta:SetIntensity( intensity ) assert( self:IsValid() ) return SetLightIntensity( self.handle, intensity ) end function light_meta:GetTransform() assert( self:IsValid() ) return MakeTransformation( GetLightTransform( self.handle ) ) end function light_meta:GetShape() assert( self:IsValid() ) return Shape( GetLightShape( self.handle ) ) end function light_meta:IsActive() assert( self:IsValid() ) return IsLightActive( self.handle ) end function light_meta:IsPointAffectedByLight( point ) assert( self:IsValid() ) return IsPointAffectedByLight( self.handle, point ) end end)();
(function() local location_meta = global_metatable( "location", "entity" ) function IsLocation( e ) return IsEntity( e ) and e.type == "location" end function Location( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "location" }, location_meta ) end end function FindLocationByTag( tag, global ) return Location( FindLocation( tag, global ) ) end function FindLocationsByTag( tag, global ) local t = FindLocations( tag, global ) for i = 1, #t do t[i] = Location( t[i] ) end return t end function location_meta:__tostring() return string.format( "Location[%d]", self.handle ) end function location_meta:GetTransform() assert( self:IsValid() ) return MakeTransformation( GetLocationTransform( self.handle ) ) end end)();
(function() local player_meta = global_metatable( "player" ) PLAYER = setmetatable( {}, player_meta ) function player_meta:__unserialize( data ) return self end function player_meta:__serialize() return "" end function player_meta:__tostring() return string.format( "Player" ) end function player_meta:GetType() return "player" end function player_meta:Respawn() return RespawnPlayer() end function player_meta:SetTransform( transform ) return SetPlayerTransform( transform ) end function player_meta:SetCamera( transform ) return SetCameraTransform( transform ) end function player_meta:SetSpawnTransform( transform ) return SetPlayerSpawnTransform( transform ) end function player_meta:SetVehicle( handle ) return SetPlayerVehicle( GetEntityHandle( handle ) ) end function player_meta:SetVelocity( velocity ) return SetPlayerVelocity( velocity ) end function player_meta:SetScreen( handle ) return SetPlayerScreen( GetEntityHandle( handle ) ) end function player_meta:SetHealth( health ) return SetPlayerHealth( health ) end function player_meta:GetTransform() return MakeTransformation( GetPlayerTransform() ) end function player_meta:GetPlayerCamera() return MakeTransformation( GetPlayerCameraTransform() ) end function player_meta:GetCamera() return MakeTransformation( GetCameraTransform() ) end function player_meta:GetVelocity() return MakeVector( GetPlayerVelocity() ) end function player_meta:GetVehicle() return Vehicle( GetPlayerVehicle() ) end function player_meta:GetGrabShape() return Shape( GetPlayerGrabShape() ) end function player_meta:GetGrabBody() return Body( GetPlayerGrabBody() ) end function player_meta:GetPickShape() return Shape( GetPlayerPickShape() ) end function player_meta:GetPickBody() return Body( GetPlayerPickBody() ) end function player_meta:GetInteractShape() return Shape( GetPlayerInteractShape() ) end function player_meta:GetInteractBody() return Body( GetPlayerInteractBody() ) end function player_meta:GetScreen() return Screen( GetPlayerScreen() ) end function player_meta:GetHealth() return GetPlayerHealth() end end)();
(function() local screen_meta = global_metatable( "screen", "entity" ) function IsScreen( e ) return IsEntity( e ) and e.type == "screen" end function Screen( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "screen" }, screen_meta ) end end function FindScreenByTag( tag, global ) return Screen( FindScreen( tag, global ) ) end function FindScreensByTag( tag, global ) local t = FindScreens( tag, global ) for i = 1, #t do t[i] = Screen( t[i] ) end return t end function screen_meta:__tostring() return string.format( "Screen[%d]", self.handle ) end function screen_meta:SetEnabled( enabled ) assert( self:IsValid() ) return SetScreenEnabled( self.handle, enabled ) end function screen_meta:GetShape() assert( self:IsValid() ) return Shape( GetScreenShape( self.handle ) ) end function screen_meta:IsEnabled() assert( self:IsValid() ) return IsScreenEnabled( self.handle ) end end)();
(function() local shape_meta = global_metatable( "shape", "entity" ) function IsShape( e ) return IsEntity( e ) and e.type == "shape" end function Shape( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "shape" }, shape_meta ) end end function FindShapeByTag( tag, global ) return Shape( FindShape( tag, global ) ) end function FindShapesByTag( tag, global ) local t = FindShapes( tag, global ) for i = 1, #t do t[i] = Shape( t[i] ) end return t end function shape_meta:__tostring() return string.format( "Shape[%d]", self.handle ) end function shape_meta:DrawOutline( r, ... ) assert( self:IsValid() ) return DrawShapeOutline( self.handle, r, ... ) end function shape_meta:DrawHighlight( amount ) assert( self:IsValid() ) return DrawShapeHighlight( self.handle, amount ) end function shape_meta:SetLocalTransform( transform ) assert( self:IsValid() ) return SetShapeLocalTransform( self.handle, transform ) end function shape_meta:SetEmissiveScale( scale ) assert( self:IsValid() ) return SetShapeEmissiveScale( self.handle, scale ) end function shape_meta:GetLocalTransform() assert( self:IsValid() ) return MakeTransformation( GetShapeLocalTransform( self.handle ) ) end function shape_meta:GetWorldTransform() assert( self:IsValid() ) return MakeTransformation( GetShapeWorldTransform( self.handle ) ) end function shape_meta:GetBody() assert( self:IsValid() ) return Body( GetShapeBody( self.handle ) ) end function shape_meta:GetJoints() assert( self:IsValid() ) local joints = GetShapeJoints( self.handle ) for i = 1, #joints do joints[i] = Joint( joints[i] ) end return joints end function shape_meta:GetLights() assert( self:IsValid() ) local lights = GetShapeLights( self.handle ) for i = 1, #lights do lights[i] = Light( lights[i] ) end return lights end function shape_meta:GetWorldBounds() assert( self:IsValid() ) local min, max = GetShapeBounds( self.handle ) return MakeVector( min ), MakeVector( max ) end function shape_meta:GetMaterialAtPos( pos ) assert( self:IsValid() ) return GetShapeMaterialAtPosition( self.handle, pos ) end function shape_meta:GetSize() assert( self:IsValid() ) return GetShapeSize( self.handle ) end function shape_meta:GetVoxelCount() assert( self:IsValid() ) return GetShapeVoxelCount( self.handle ) end function shape_meta:IsVisible( maxDist, rejectTransparent ) assert( self:IsValid() ) return IsShapeVisible( self.handle, maxDist, rejectTransparent ) end function shape_meta:IsBroken() return not self:IsValid() or IsShapeBroken( self.handle ) end end)();
(function() local trigger_meta = global_metatable( "trigger", "entity" ) function IsTrigger( e ) return IsEntity( e ) and e.type == "trigger" end function Trigger( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "trigger" }, trigger_meta ) end end function FindTriggerByTag( tag, global ) return Trigger( FindTrigger( tag, global ) ) end function FindTriggersByTag( tag, global ) local t = FindTriggers( tag, global ) for i = 1, #t do t[i] = Trigger( t[i] ) end return t end function trigger_meta:__tostring() return string.format( "Trigger[%d]", self.handle ) end function trigger_meta:SetTransform( transform ) assert( self:IsValid() ) return SetTriggerTransform( self.handle, transform ) end function trigger_meta:GetTransform() assert( self:IsValid() ) return MakeTransformation( GetTriggerTransform( self.handle ) ) end function trigger_meta:GetWorldBounds() assert( self:IsValid() ) local min, max = GetTriggerBounds( self.handle ) return MakeVector( min ), MakeVector( max ) end function trigger_meta:IsBodyInTrigger( handle ) assert( self:IsValid() ) return IsBodyInTrigger( self.handle, GetEntityHandle( handle ) ) end function trigger_meta:IsVehicleInTrigger( handle ) assert( self:IsValid() ) return IsVehicleInTrigger( self.handle, GetEntityHandle( handle ) ) end function trigger_meta:IsShapeInTrigger( handle ) assert( self:IsValid() ) return IsShapeInTrigger( self.handle, GetEntityHandle( handle ) ) end function trigger_meta:IsPointInTrigger( point ) assert( self:IsValid() ) return IsPointInTrigger( self.handle, point ) end function trigger_meta:IsEmpty( demolision ) assert( self:IsValid() ) local empty, highpoint = IsTriggerEmpty( self.handle, demolision ) return empty, highpoint and MakeVector( highpoint ) end end)();
(function() local vehicle_meta = global_metatable( "vehicle", "entity" ) function IsVehicle( e ) return IsEntity( e ) and e.type == "vehicle" end function Vehicle( handle ) if handle > 0 then return setmetatable( { handle = handle, type = "vehicle" }, vehicle_meta ) end end function FindVehicleByTag( tag, global ) return Vehicle( FindVehicle( tag, global ) ) end function FindVehiclesByTag( tag, global ) local t = FindVehicles( tag, global ) for i = 1, #t do t[i] = Vehicle( t[i] ) end return t end function vehicle_meta:__tostring() return string.format( "Vehicle[%d]", self.handle ) end function vehicle_meta:Drive( drive, steering, handbrake ) assert( self:IsValid() ) return DriveVehicle( self.handle, drive, steering, handbrake ) end function vehicle_meta:GetTransform() assert( self:IsValid() ) return MakeTransformation( GetVehicleTransform( self.handle ) ) end function vehicle_meta:GetBody() assert( self:IsValid() ) return Body( GetVehicleBody( self.handle ) ) end function vehicle_meta:GetHealth() assert( self:IsValid() ) return GetVehicleHealth( self.handle ) end function vehicle_meta:GetDriverPos() assert( self:IsValid() ) return MakeVector( GetVehicleDriverPos( self.handle ) ) end function vehicle_meta:GetGlobalDriverPos() return self:GetTransform():ToGlobal( self:GetDriverPos() ) end end)();
for i = 1, #__RUNLATER do local f = loadstring(__RUNLATER[i]) if f then pcall(f) end end
